"""This module provides the GradationSettings class."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.FhwaVariable.core_data.calculator.setting_group import SettingGroup
from xms.FhwaVariable.core_data.variables.variable import Variable

# 4. Local modules


class AdministrationSettings(SettingGroup):
    """Provides definitions for the gradation setings."""

    def __init__(self, name, version, agency, dev):
        """Initializes the gradation settings values."""
        super().__init__(name, version, agency, dev)

        # Bridge Scour
        self.input['Bridge scour'] = {}
        self.input['Bridge scour']['Min layer thickness'] = Variable(
            'Minimum layer thickness', 'float', 2, precision=2, limits=(0.0, self.max_value),
            unit_type=['length'], native_unit='ft',
            us_units=self.us_short_length, si_units=self.si_short_length,
            note='If the layer below the current layer is weaker than the current layer, if the current layer is '
                 'thinner than this value, calulations will continue to the next layer.')

        # Channels
        # self.input['Channel'] = {}

        # Culverts
        self.input['Culvert'] = {}
        self.culvert_equivalent_depth_options = [
            'Always', 'When depth > rise / 2', 'use hydraulic depth < rise', 'when depth > 0.95 * rise',
            'For shapes other than box', 'Never'
        ]
        self.input['Culvert']['Use equivalent depth'] = Variable(
            'Use equivalent depth instead of hydraulic depth for closed shapes with a top width < half span', 'list',
            3, self.culvert_equivalent_depth_options, complexity=2)
        self.exit_loss_options = [
            'Standard method', 'USU method'
        ]
        self.input['Culvert']['Exit loss method'] = Variable(
            'Exit loss method', 'list',
            0, self.exit_loss_options, complexity=0,
            note='The standard method ignores the downstream velocity head (HDS5 and conservative); USU method uses '
            '"Borda-Carnot equation" to determine exit loss.')

        # GVF
        self.input['Gradually Varied Flow'] = {}
        self.input['Gradually Varied Flow']['Use brink depth'] = Variable(
            'Use brink depth instead of critical depth as a minimum downstream depth', 'bool',
            False, [], complexity=1)

        # TODO: Add Design/analysis modes for existing/proposed folders (Consider prior item and other settings)
