"""Class to listen for system theme changes."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules
import subprocess
# from Foundation import NSDistributedNotificationCenter, NSObject
# import ctypes

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


# MacOs
# class ThemeChangeListener(NSObject):
#     """Class to listen for system theme changes."""
#     def init(self):
#         """Initialize the class."""
#         self = super(ThemeChangeListener, self).init()
#         if self is None:
#             return None
#         NSDistributedNotificationCenter.defaultCenter().addObserver_selector_name_object_(
#             self, self.theme_changed_, "AppleInterfaceThemeChangedNotification", None
#         )
#         return self

#     def theme_changed_(self, notification):
#         """Called when the system theme changes."""
#         new_theme = get_macos_theme()
#         print(f"Theme changed to: {new_theme}")


def get_macos_theme():
    """Get the current macOS theme."""
    try:
        result = subprocess.run(
            ["defaults", "read", "-g", "AppleInterfaceStyle"],
            capture_output=True,
            text=True
        )
        return "dark" if "Dark" in result.stdout else "light"
    except Exception as e:
        print(f"Error reading macOS theme: {e}")
        return None


# Windows
def get_windows_theme():
    """Get the current Windows theme."""
    try:
        import winreg  # Imported here to prevent issues when running on non-windows systems.
        registry = winreg.ConnectRegistry(None, winreg.HKEY_CURRENT_USER)
        key = winreg.OpenKey(registry, r"Software\Microsoft\Windows\CurrentVersion\Themes\Personalize")
        value, _ = winreg.QueryValueEx(key, "AppsUseLightTheme")
        winreg.CloseKey(key)
        return "light" if value == 1 else "dark"
    except Exception as e:
        print(f"Error reading registry: {e}")
        return None


# def theme_change_callback(hwnd, msg, wparam, lparam):
#     """Called when the system theme changes."""
#     if msg == 0x031A:  # WM_SETTINGCHANGE
#         new_theme = get_windows_theme()
#         print(f"Theme changed to: {new_theme}")


# def listen_for_theme_changes():
#     """Listen for system theme changes on Windows."""
#     wndproctype = ctypes.WINFUNCTYPE(ctypes.c_long, ctypes.c_int, ctypes.c_uint, ctypes.c_int, ctypes.c_int)
#     wndproc = wndproctype(theme_change_callback)

#     hinst = ctypes.windll.kernel32.GetModuleHandleW(None)
#     wndclass = ctypes.wintypes.WNDCLASS()
#     wndclass.lpfnWndProc = wndproc
#     wndclass.hInstance = hinst
#     wndclass.lpszClassName = "ThemeChangeListener"
#     ctypes.windll.user32.RegisterClassW(ctypes.byref(wndclass))

#     hwnd = ctypes.windll.user32.CreateWindowExW(0, wndclass.lpszClassName, "ThemeChangeListener", 0, 0, 0, 0, 0, 0, 0,
#                                                 hinst, None)
#     ctypes.windll.user32.UpdateWindow(hwnd)

#     msg = ctypes.wintypes.MSG()
#     while ctypes.windll.user32.GetMessageW(ctypes.byref(msg), hwnd, 0, 0) != 0:
#         ctypes.windll.user32.TranslateMessage(ctypes.byref(msg))
#         ctypes.windll.user32.DispatchMessageW(ctypes.byref(msg))


# if __name__ == "__main__":  # MacOs
#     current_theme = get_macos_theme()
#     print(f"Current macOS theme: {current_theme}")

#     listener = ThemeChangeListener.alloc().init()
#     from PyObjCTools import AppHelper
#     AppHelper.runConsoleEventLoop()

# if __name__ == "__main__":  # Windows
#     current_theme = get_windows_theme()
#     print(f"Current Windows theme: {current_theme}")
#     listen_for_theme_changes()
