"""Classes to Define the view-model of a dialog."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass
from typing import Optional
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


@dataclass
class WindowBase:
    """Data class to represent window properties."""
    window_title: str = ""
    icon: Optional[str] = None
    modal: bool = True
    parent_uuid: Optional[uuid.UUID] = None

    # Screen, screen size, and screen position
    maximized: bool = False
    minimized: bool = False
    x: int = 0
    y: int = 0
    width: int = 0
    height: int = 0

    resizable: bool = True  # If you want this to be False, you need to implement it
