"""Functions used to determine distances."""
__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
import math

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class Point:
    """Class that defines an XY point."""

    def __init__(self, x: float, y: float):
        """Initializes the xy point.

        Args:
            x (float): the x value of the xy point
            y (float): the y value of the xy point
        """
        self.x = x
        self.y = y


def xy_pt_distance(first_point: Point, second_point: Point) -> float:
    """Determine the distance between two points (Point).

    Args:
        first point (Point): first point of an xy line segment
        second point (Point): second point of an xy line segment

    Returns:
        float: the distance between the two points
    """
    x_sqr = (first_point.x - second_point.x)**2.0
    y_sqr = (first_point.y - second_point.y)**2.0
    dist = math.sqrt(x_sqr + y_sqr)
    return dist


def xy_distance(first_point_x: float, first_point_y: float, second_point_x: float, second_point_y: float) -> float:
    """Determine the distance between two points (X & Y values).

    Args:
        first point X (Point): x value of the first point of an xy line segment
        first point y (Point): y value of the first point of an xy line segment
        second point X (Point): x value of the second point of an xy line segment
        second point y (Point): y value of the second point of an xy line segment

    Returns:
        float: the distance between the two points
    """
    first_point = Point(first_point_x, first_point_y)
    second_point = Point(second_point_x, second_point_y)
    return xy_pt_distance(first_point, second_point)
