"""This module checks for data errors in the simulation."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query

# 4. Local modules
from xms.adh.data.adh_query_data import AdhQueryData
from xms.adh.data.xms_data import XmsData
from xms.adh.data.xms_query_data import XmsQueryData
from xms.adh.dmi.adh_model_check import AdHModelChecker


def main(xms_data: XmsData):
    """
    Entry point for the AdH model check script.

    Args:
        xms_data (XmsData): The XMS data object.
    """
    adh_query_data = AdhQueryData(xms_data)
    checker = AdHModelChecker(adh_query_data)
    checker.run_checks()
    if checker.errors:
        query.add_model_check_errors(checker.errors)
        query.send()


if __name__ == "__main__":  # pragma: no cover
    query = Query()
    xms_data = XmsQueryData(query)
    main(xms_data)
