"""Imports an AdH simulation."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.dialogs.feedback_thread import FeedbackThread
from xms.guipy.dialogs.process_feedback_dlg import run_feedback_dialog

# 4. Local modules
from xms.adh.file_io.readbc import adh_read


def import_adh_with_feedback():
    """Imports AdH data and displays feedback using a feedback dialog."""
    class ImportAdhThread(FeedbackThread):
        """Feedback thread for importing AdH files."""
        def __init__(self):
            """Initialize the AdH import thread."""
            super().__init__(None)
            task = 'AdH Simulation Import'
            self.display_text |= {
                'title': task,
                'working_prompt': f'Running {task}. Please wait...',
                'warning_prompt': f'Warning(s) encountered during {task}. Review log output for more details.',
                'error_prompt': f'Error(s) encountered during {task}. Review log output for more details.',
                'success_prompt': f'Successfully ran {task}.',
            }

        def _run(self):
            """Run AdH simulation import."""
            adh_read(self._query, self._log)

    worker = ImportAdhThread()
    run_feedback_dialog(worker)
