"""AdH data protocol."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.constraint import Grid as CoGrid
from xms.data_objects.parameters import Coverage

# 4. Local modules
from xms.adh.components.vessel_component import VesselComponent
from xms.adh.data.bc_io import BcIO
from xms.adh.data.lazy_load import LazyField
from xms.adh.data.materials_io import MaterialsIO
from xms.adh.data.model_control import ModelControl
from xms.adh.data.sediment_constituents_io import SedimentConstituentsIO
from xms.adh.data.sediment_materials_io import SedimentMaterialsIO
from xms.adh.data.transport_constituents_io import TransportConstituentsIO


class AdhData:
    """AdH data."""
    model_control: ModelControl | None = LazyField()
    co_grid: CoGrid | None = LazyField()
    geom_uuid: str | None = LazyField()
    bc_io: BcIO | None = LazyField()
    materials_io: MaterialsIO | None = LazyField()
    transport_constituents_io: TransportConstituentsIO | None = LazyField()
    sediment_materials_io: SedimentMaterialsIO | None = LazyField()
    sediment_constituents_io: SedimentConstituentsIO | None = LazyField()
    vessel_coverages: list[Coverage] | None = LazyField()
    vessel_components: list[VesselComponent] | None = LazyField()

    def _load_model_control(self) -> ModelControl | None:
        """Load and return the model control.

        Returns:
            The model control.
        """
        return None

    def _load_co_grid(self) -> CoGrid | None:
        """
        Loads the CoGrid value.

        Returns:
            The CoGrid value.
        """
        return None

    def _load_bc_io(self) -> BcIO | None:
        """
        Loads the BcIO value.

        Returns:
            The boundary BcIO value.
        """
        return None

    def _load_materials_io(self) -> MaterialsIO | None:
        """Loads the MaterialsIO value.

        Returns:
            The MaterialsIO value.
        """
        return None

    def _load_transport_constituents_io(self) -> TransportConstituentsIO | None:
        """Loads the TransportConstituentsIO value.

        Returns:
            The TransportConstituentsIO value.
        """
        return None

    def _load_sediment_materials_io(self) -> SedimentMaterialsIO | None:
        """Loads the SedimentMaterialsIO value.

        Returns:
            The SedimentMaterialsIO value.
        """
        return None

    def _load_sediment_constituents_io(self) -> SedimentConstituentsIO | None:
        """Loads the SedimentConstituentsIO value.

        Returns:
            The SedimentConstituentsIO value.
        """
        return None

    def _load_vessel_coverages(self) -> list[Coverage] | None:
        """
        Loads the vessel coverages.

        Returns:
            The list of vessel coverages.
        """
        return None

    def _load_vessel_components(self) -> list[VesselComponent] | None:
        """
        Loads the vessel components.

        Returns:
            The list of vessel components.
        """
        return None
