"""This module contains information regarding boundary condition cards."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class CardInfo:
    """Contains lists and dictionaries useful for boundary condition cards."""
    arc_types = [
        'Off',
        'Natural outflow (OB OF)',
        'Discharge (NB DIS)',
        'Flow (NB OVL)',  # NB VEL in AdH 5.0 is NB OVL in AdH 4.6
        'Water surface elevation (NB OTW)',
        'Spillway (NB SPL)',
        'Tidal boundary (NB TID)',
        'Stage discharge boundary (NB SDR)',
        'Flow output inside grid (NB OUT)',
        # 'Velocity 2D (DB OVL)',  # not in AdH 4.6
        'Velocity and depth (DB OVH)',
        'Stationary lid elevation (DB LDE)',
        'Depth of water under stationary lid (DB LDH)',
        'Floating stationary object (DB LID)'
    ]
    arc_card_to_index = {
        '': 0,
        'OF': 1,
        'DIS': 2,
        # 'VEL': 3,  # NB VEL in AdH 5.0 is NB OVL in AdH 4.6
        'OVL': 3,
        'OTW': 4,
        'SPL': 5,
        'TID': 6,
        'SDR': 7,
        'OUT': 8,
        'OVH': 9,
        'LDE': 10,
        'LDH': 11,
        'LID': 12
    }
    arc_card_to_id_file = {
        '': "bc_arc_off.display_ids",
        'OF': "bc_arc_ob_of.display_ids",
        'DIS': "bc_arc_nb_dis.display_ids",
        'OVL': "bc_arc_nb_ovl.display_ids",
        'OTW': "bc_arc_nb_otw.display_ids",
        'SPL': "bc_arc_nb_spl.display_ids",
        'TID': "bc_arc_nb_tid.display_ids",
        'SDR': "bc_arc_nb_sdr.display_ids",
        'OUT outflow': "bc_arc_nb_out_outflow.display_ids",
        'OUT inflow': "bc_arc_nb_out_inflow.display_ids",
        # 'OVL': "bc_arc_db_ovl.display_ids",  # not in AdH 4.6
        'OVH': "bc_arc_db_ovh.display_ids",
        'LDE': "bc_arc_db_lde.display_ids",
        'LDH': "bc_arc_db_ldh.display_ids",
        'LID': "bc_arc_db_lid.display_ids"
    }
    point_types = [
        'Off',
        # 'Velocity 2D (DB OVL)',  # not in AdH 4.6
        'Velocity and depth (DB OVH)',
        'Stationary lid elevation (DB LDE)',
        'Depth of water under stationary lid (DB LDH)',
        'Floating stationary object (DB LID)',
        'Wind Definition (OP WND)'
    ]
    point_card_to_index = {
        '': 0,
        # 'OVL': 1,
        'OVH': 1,
        'LDE': 2,
        'LDH': 3,
        'LID': 4,
        'WND': 5
    }
    point_card_to_id_file = {
        '': "bc_point_off.display_ids",
        'OVL': "bc_point_db_ovl.display_ids",
        'OVH': "bc_point_db_ovh.display_ids",
        'LDE': "bc_point_db_lde.display_ids",
        'LDH': "bc_point_db_ldh.display_ids",
        'LID': "bc_point_db_lid.display_ids",
        'WND': "bc_point_db_wnd.display_ids"
    }
    snap_options = ['Point snap', 'Edgestring snap', 'Midstring snap']
