"""This module tracks the ongoing progress of an AdH run."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query

# 4. Local modules


class AdHTracker:
    """This class tracks the progress of an AdH run."""
    prog = None
    query = None
    echo_file = None
    echo_pos = 0
    error_file = None
    error_pos = 0

    def __init__(self):
        """Does nothing except construct the class."""
        pass

    @staticmethod
    def progress_function():
        """Method called inside the progress loop for computing percent done."""
        if not AdHTracker.echo_file:
            AdHTracker.echo_file = AdHTracker.prog.command_line_output_file
            AdHTracker.error_file = AdHTracker.echo_file.replace(".txt", "Error.txt")

        found_iter = False
        current_percent = 0
        try:
            with open(AdHTracker.echo_file, 'r') as f:
                f.seek(AdHTracker.echo_pos)
                echo_line = f.readline()
                while echo_line:
                    if echo_line.endswith('\n') or echo_line.endswith('\r'):
                        AdHTracker.echo_pos = f.tell()
                        echo_percent_vals = echo_line.split('%')
                        if len(echo_percent_vals) == 2:
                            echo_vals = echo_percent_vals[1].split()
                            try:
                                current_percent = float(echo_vals[0].strip(','))
                            except ValueError:
                                pass
                            found_iter = True
                    echo_line = f.readline()
            with open(AdHTracker.error_file, 'r') as f:
                f.seek(AdHTracker.error_pos)
                error_line = f.readline()
                while error_line:
                    if error_line.endswith('\n') or error_line.endswith('\r'):
                        AdHTracker.error_pos = f.tell()
                    error_line = f.readline()
        except Exception:
            pass  # File might not exist yet

        if found_iter:
            AdHTracker.query.update_progress_percent(int(current_percent))

    @staticmethod
    def start_tracking():
        """Entry point for the AdH progress script."""
        AdHTracker.query = Query(progress_script=True)
        AdHTracker.prog = AdHTracker.query.xms_agent.session.progress_loop

        AdHTracker.prog.set_progress_function(AdHTracker.progress_function)
        AdHTracker.prog.start_loop()
