"""Model native export script."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query, XmsEnvironment as XmEnv
from xms.guipy.dialogs.process_feedback_dlg import run_feedback_dialog

# 4. Local modules
from xms.aeolis.dmi.xms_data import XmsData
from xms.aeolis.feedback.model_native_export_thread import ModelNativeExportThread


def main():
    """Entry point wrapper."""
    try:
        query = Query()
        data = XmsData(query)
        worker = ModelNativeExportThread(data)
        run_feedback_dialog(worker)
    except Exception as ex:
        XmEnv.report_error(ex)


if __name__ == "__main__":  # pragma: no cover
    main()
