"""Python wrapping for xms.api._xmsapi.dmi.MetaDataResult."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api._xmsapi.dmi import MetaDataResult as CMetaDataResult
from xms.api.dmi import Context as PyContext
from xms.api.dmi.ResultBase import ResultBase


class MetaDataResult(ResultBase):
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.MetaDataResult objects."""
    def __init__(self, instance=None):
        """Construct the wrapper.

        Note that this is a low-level API object that should not be constructed directly.

        Args:
            instance (xms.api._xmsapi.dmi.MetaDataResult): The C++ object to wrap
        """
        if instance is None:
            instance = CMetaDataResult()
        super().__init__(instance)

    @property
    def context(self):
        """Returns the xms.api.dmi.Context associated with the MetaDataResult."""
        return PyContext(instance=self._instance.GetContext())

    @context.setter
    def context(self, ctxt):
        """Set the Context associated with the MetaDataResult.

        Args:
            ctxt (xms.api.dmi.Context): The MetaDataResult Context
        """
        self._instance.SetContext(ctxt._instance)
