"""Python wrapping for xms.api._xmsapi.dmi.ResultBase."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class ResultBase:
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.ResultBase objects."""
    def __init__(self, instance):
        """Construct the wrapper.

        Note that this is a low-level API object that should not be constructed directly.

        Args:
            instance (xms.api._xmsapi.dmi.ResultBase): The C++ object to wrap
        """
        self._instance = instance

    @property
    def status(self):
        """Returns the status code of the DataResult."""
        return self._instance.GetStatus()

    @status.setter
    def status(self, status_code):
        """Sets the status code of the DataResult.

        Args:
            status_code (int): The status code of the DataResult.
                RC_SUCCESS = 0
                RC_ERROR = 1
        """
        self._instance.SetStatus(status_code)
