"""The help pane in the Structure properties dialog."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.dialogs.plot_and_table_widget import PlotsAndTableWidget

# 4. Local modules


class StructureSrhPlotTab:
    """The profiles tab in the structure dialog."""
    def __init__(self, parent, widgets, plot_data):
        """Initializes the class.

        Args:
            parent (:obj:`QWidget`): Parent dialog
            widgets (:obj:`dict`): Dictionary of widgets
            plot_data (:obj:`PlotsAndTableDataSrh`): Plot data
        """
        self._parent = parent
        self._parent_widgets = widgets
        self._widgets = {}
        self._plot_data = plot_data
        self._add_widgets()

    def _add_widgets(self):
        """Setup the UI."""
        vlayout = self._parent_widgets['tab0_scroll_area_vert_layout']

        plot_widget = PlotsAndTableWidget(self._parent, self._plot_data)
        self._parent_widgets['plot_table_widget'] = plot_widget
        vlayout.addWidget(plot_widget)
