"""This is a table widget for specifying atmospheric values over time."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.delegates.edit_field_validator import EditFieldValidator
from xms.guipy.models.rename_model import RenameModel
from xms.guipy.validators.qx_double_validator import QxDoubleValidator

# 4. Local modules
from xms.cmsflow.gui.cmsflow_table_widget import CmsflowTableWidget


class AtmosphericTableWidget(CmsflowTableWidget):
    """Table widget base class."""
    def __init__(self, parent, data_frame):
        """Construct the widget.

        Args:
            parent (Something derived from :obj:`QObject`): The parent object.
            data_frame (pandas.DataFrame): The model data.

        """
        self.rename_model = None
        self.edit_delegate = None
        self.dbl_validator = None
        default_values = {
            'time': 0.0,
            'air_temp': 0.0,
            'dewpoint': 0.0,
            'cloud_cover': 0.0,
            'solar_radiation': 0.0,
        }
        super().__init__(parent, data_frame, 0, default_values)

    def setup_ui(self):
        """Sets up the delegates, validators, and filter model for this table."""
        column_names = ['Time (hr)', 'Air Temp (°C)', 'Dewpoint (°C)', 'Cloud Cover', 'Solar Radiation (W/m²)']
        self.rename_model = RenameModel(column_names, self)
        self.dbl_validator = QxDoubleValidator(parent=self)
        self.edit_delegate = EditFieldValidator(self.dbl_validator)
        delegates = {
            0: self.edit_delegate,
            1: self.edit_delegate,
            2: self.edit_delegate,
            3: self.edit_delegate,
            4: self.edit_delegate
        }
        super()._setup_ui(delegates, False, False, self.rename_model)
