"""Python wrapping for xms._data_objects.parameters.UGrid."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.data_objects._data_objects.parameters import UGrid as CUGrid
from xms.data_objects.parameters.spatial.spatial_vector.SpatialVector import SpatialVector


class UGrid(SpatialVector):
    """The pure Python wrapper for C++ exposed xms._data_objects.parameters.UGrid objects."""
    def __init__(self, *args, **kwargs):
        """Construct the wrapper.

        Note:
            This wrapper encourages the use of the CoGrid library. Only the 'cogrid_file' property is directly exposed.
            The old serialization and H5 dump implementations are deprecated. Use xmsconstraint to write geometries to
            files and construct this wrapper with the filename to send back to XMS (can set base class 'name', 'uuid',
            and 'projection' attributes). Use xmsconstraint to read CoGrid files of geometries requested from XMS.

        Args:
            *args
                Union[str, CUGrid]: Path and filename of the CoGrid file or the C++ wrapped UGrid instance
            **kwargs
                cogrid_file (str): Path and filename of the CoGrid file
                instance (CUGrid): The C++ wrapped UGrid instance
                See SpatialVector for base class kwargs
        """
        if args:  # Can either provide a CoGrid file or C++ wrapped instance.
            pos_arg = args[0]
            if isinstance(pos_arg, str):
                kwargs['cogrid_file'] = pos_arg
            elif isinstance(pos_arg, CUGrid):
                kwargs['instance'] = pos_arg

        if 'cogrid_file' in kwargs:  # Read from CoGrid file
            kwargs['instance'] = CUGrid(kwargs['cogrid_file'])

        if 'instance' not in kwargs:
            raise ValueError('Must construct with a CoGrid filename or C++ wrapped instance.')
        super().__init__(**kwargs)

    @property
    def cogrid_file(self):
        """Returns the CoGrid file as a str."""
        return self._instance.GetXmUGridFile()
