"""Float formatter for Dredging toll table delegate."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtGui import QColor
from PySide2.QtWidgets import QStyle, QStyledItemDelegate

# 3. Aquaveo modules

# 4. Local modules
from xms.ewn.data import ewn_cov_data_consts as const


class EditFieldDelegate(QStyledItemDelegate):
    """Float formatter for Dredging toll table delegate."""
    def __init__(self, parent=None):
        """Initializes the class.

        Args:
            parent (Something derived from :obj:`QWidget`): The parent window.
        """
        super().__init__(parent)

    def paint(self, painter, option, index):
        """Override of QStyledItemDelegate method of same name.

        Args:
            painter (:obj:`QPainter`): The painter.
            option (:obj:`QStyleOptionViewItem`): The style options.
            index (:obj:`QModelIndex`): The index in the model.
        """
        # Get the type
        sediment_type = int(float(index.model().index(index.row(), const.COL_SEDIMENT_TYPE).data()))
        col = index.column()

        # background color
        if sediment_type in [const.SEDIMENT_TYPE_SPECIFY_CUT, const.SEDIMENT_TYPE_SPECIFY_FILL]:
            # specified bg color
            painter.fillRect(option.rect, QColor("lightYellow"))
        else:
            # Available bg color
            painter.fillRect(option.rect, QColor("lightBlue"))

        # draw selection highlight
        if option.state & QStyle.State_Selected:
            painter.fillRect(option.rect, option.palette.highlight())

        # center the text vertically then draw
        val = float(index.data())
        if sediment_type == const.SEDIMENT_TYPE_SPECIFY_CUT:
            # format with negative indicator ()
            if col not in [const.COL_AVAILABLE_VOLUME, const.COL_FILL_VOLUME]:
                painter.drawText(option.rect, index.flags(), f'({val:.2f})')
        elif sediment_type == const.SEDIMENT_TYPE_SPECIFY_FILL:
            if col not in [const.COL_AVAILABLE_VOLUME, const.COL_CUT_VOLUME]:
                painter.drawText(option.rect, index.flags(), f'{val:.2f}')
        elif sediment_type == const.SEDIMENT_TYPE_AVAILABLE_CUT:
            if col not in [const.COL_REQUIRED_VOLUME, const.COL_FILL_VOLUME]:
                painter.drawText(option.rect, index.flags(), f'({val:.2f})')
        else:
            if col not in [const.COL_REQUIRED_VOLUME, const.COL_CUT_VOLUME]:
                painter.drawText(option.rect, index.flags(), f'{val:.2f}')
