"""GsshaSimData class."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.sim_data import SimData

# 4. Local modules


class GsshaSimData(SimData):
    """Manages the data file for a simulation component."""
    GSSHA_DATA_VERSION = 'GSSHA_DATA_VERSION'  # To track changes to the generic model
    LATEST_VERSION = 1  # The latest version

    def __init__(self, data_file: str | Path):
        """
        Initialize the data class.

        Args:
            data_file: The netcdf file (with path) associated with this instance data. Probably the owning
                       component's main file.
        """
        # _migrate() will be called by base class.
        super().__init__(data_file)

        # Always add the GSSHA_DATA_VERSION string, set to the latest version
        self.info.attrs[self.GSSHA_DATA_VERSION] = self.LATEST_VERSION
        # self.commit()

    def _migrate(self):
        """Method to migrate data from different versions of the file."""
        pass
