"""type_aliases.py."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules
import numpy as np  # noqa: F401 - Used in type hinting
# import numpy.typing as npt

# 3. Aquaveo modules
from xms.api.dmi import ActionRequest

# 4. Local modules

# Type aliases
Messages = list[tuple[str, str]]
"""List of (str, str): first string is message level (DEBUG, ERROR, WARNING, INFO), second string is message text."""

ActionRv = tuple[Messages, list[ActionRequest]]
"""Return value for an action method."""

# IntArray = 'npt.NDArray[int]'
IntArray = 'np.typing.NDArray[int]'
"""np.ndarray of int."""

FloatArray = 'np.typing.NDArray[float]'
"""np.ndarray of float."""

Pt3dArray = 'np.typing.NDArray[np.typing.NDArray[np.float_]]'
"""np.ndarray of np.ndarray of float to represent a sequence of points."""
