"""A dialog that saves script text to a file."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtWidgets import QDialog

# 3. Aquaveo modules

# 4. Local modules
from xms.guipy.testing.script_saver_dialog_ui import Ui_ScriptSaverDialog


class ScriptSaverDialog(QDialog):
    """A dialog that saves script text to a file."""
    def __init__(self, parent, script_filename):
        """Initializes the class.

        Args:
            parent: Parent window.
            script_filename (str): Filepath to script file.
        """
        super().__init__(parent)

        self.script_filename = script_filename
        self.ui = Ui_ScriptSaverDialog()
        self.ui.setupUi(self)
        self.ui.txtSavingTo.setText(f'File: {script_filename}')


def main():
    """Test driver for the dialog."""
    import sys  # noqa: AQU116
    from PySide2.QtWidgets import QApplication

    app = QApplication(sys.argv)
    dialog = ScriptSaverDialog(None, 'C:/temp/script_text.txt')
    dialog.exec()
    sys.exit(app.exec_())


if __name__ == "__main__":
    main()
