"""Determines if a series of points are clock-wise."""
# 1. Standard python modules
import math

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class OrientationChecker:
    """This object determines if a series of points are clock-wise."""

    def __init__(self):
        """Constructor."""
        pass

    def _calculate_deviation(self, p1, p2, p3):
        """Calculate deviation.

        Args:
            p1 (list): The first point
            p2 (list): The second point
            p3 (list): The third point

        Returns:
            float: The deviation
        """
        x1 = p1[0]
        y1 = p1[1]
        x2 = p2[0]
        y2 = p2[1]
        x3 = p3[0]
        y3 = p3[1]
        angle12 = math.atan2(y2 - y1, x2 - x1) * 180 / math.pi
        angle23 = math.atan2(y3 - y2, x3 - x2) * 180 / math.pi
        dev = angle23 - angle12
        if dev > 180:
            dev = dev - 360
        if dev < -180:
            dev = 360 + dev
        return dev

    def is_clockwise(self, points, threshold=0.1):
        """Determine if a sequence of points is in clockwise order.

        Args:
            points (list): The point locations
            threshold (float): Tolerance to use when comparing locations

        Returns:
            bool: True if clockwise, False if counter-clockwise, None if 8-shaped
        """
        points = points + points[0:2]
        sumangle = 0
        for i in range(0, len(points) - 2):
            p1 = points[i]
            p2 = points[i + 1]
            p3 = points[i + 2]
            dev = self._calculate_deviation(p1, p2, p3)
            sumangle = sumangle + dev
        if abs(sumangle - 360) < threshold:  # Counter clock-wise
            return False
        elif abs(sumangle + 360) < threshold:  # Clock-wise
            return True
        else:
            return None  # 8-shaped
