"""PrtComponent class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.components.model_component_base import ModelComponentBase
from xms.mf6.gui.prt.prt_dialog import PrtDialog


class PrtComponent(ModelComponentBase):
    """A Dynamic Model Interface (DMI) component for a GWT (Groundwater Flow) model."""
    def __init__(self, main_file):
        """Initializes the class.

        Args:
            main_file: The main file associated with this component.
        """
        super().__init__(main_file)
        self.ftype = 'PRT6'  # package ftype
        self.dialog = PrtDialog  # dialog class
        self.link_param = 'GWF_UGRID'  # GWT_UGRID doesn't work
        self.model_str = 'PRT'
