"""ExchangeDataBase class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.list_package_data import ListPackageData


class ExchangeDataBase(ListPackageData):
    """Data class to hold the info from an exchange package file."""
    def __init__(self, **kwargs):
        """Initializes the class.

        Args:
            **kwargs: Arbitrary keyword arguments.

        Keyword Args:
            ftype (str): The file type used in the GWF name file (e.g. 'WEL6')
            mfsim (MfsimData): The simulation.
            model (GwfData or GwtData): The GWF/GWT model. Will be None for TDIS, IMS, Exchanges (things below mfsim)
            grid_info (GridInfo): Information about the grid. Only used when testing individual packages. Otherwise,
             it comes from model and dis
        """
        super().__init__(**kwargs)
        self._exgtype = ''  # exgtype
        self._exgmnamea = ''  # exgmnamea
        self._exgmnameb = ''  # exgmnameb

    @property
    def exgtype(self) -> str:
        """Return the property value."""
        return self._exgtype

    @exgtype.setter
    def exgtype(self, value: str) -> None:
        """Set the property value.

        Args:
            value: The value.
        """
        self._exgtype = value

    @property
    def exgmnamea(self) -> str:
        """Return the property value."""
        return self._exgmnamea

    @exgmnamea.setter
    def exgmnamea(self, value: str) -> None:
        """Set the property value.

        Args:
            value: The value.
        """
        self._exgmnamea = value

    @property
    def exgmnameb(self) -> str:
        """Return the property value."""
        return self._exgmnameb

    @exgmnameb.setter
    def exgmnameb(self, value: str) -> None:
        """Set the property value.

        Args:
            value: The value.
        """
        self._exgmnameb = value
