"""GWE exchange data classes."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.exchanges.gwx_gwx_data_base import GwxGwxDataBase
from xms.mf6.data.options_block import OptionsBlock
from xms.mf6.gui.options_defs import Checkbox, CheckboxButton, CheckboxComboBox


class GweGweData(GwxGwxDataBase):
    """Data class to hold the info from a GWE-GWE exchange package file."""
    def __init__(self, **kwargs):
        """Initializes the class.

        Args:
            **kwargs: Arbitrary keyword arguments.

        Keyword Args:
            ftype (str): The file type used in the GWF name file (e.g. 'WEL6')
            mfsim (MfsimData): The simulation.
            model (GwfData or GwtData): The GWF/GWT model. Will be None for TDIS, IMS, Exchanges (things below mfsim)
            grid_info (GridInfo): Information about the grid. Only used when testing individual packages. Otherwise,
             it comes from model and dis
        """
        super().__init__(**kwargs)

    def dialog_title(self):
        """Returns the title to show in the dialog.

        You should override this method.

        Returns:
            (str): The dialog title.
        """
        return 'Groundwater Energy Transport (GWE) Exchange'

    def _setup_options(self):
        """Returns the definition of all the available options.

        Returns:
            (OptionsBlock): See description.
        """
        return OptionsBlock(
            [
                CheckboxButton(
                    'AUXILIARY',
                    button_text='Auxiliary Variables...',
                    check_box_method='on_chk_auxiliary',
                    button_method='on_btn_auxiliary'
                ),
                Checkbox('BOUNDNAMES', brief='Allow boundary names', check_box_method='on_chk_boundnames'),
                Checkbox('PRINT_INPUT', brief='Print input to listing file'),
                Checkbox('PRINT_FLOWS', brief='Print flows to listing file'),
                Checkbox('SAVE_FLOWS', brief='Save flows to budget file'),
                CheckboxComboBox(
                    'ADV_SCHEME',
                    brief='Scheme used to solve the advection term',
                    items=['upstream', 'central', 'TVD'],
                    value='upstream'
                ),
                Checkbox('CND_XT3D_OFF', brief='Deactivate the xt3d method for the dispersive flux'),
                Checkbox('CND_XT3D_RHS', brief='Add xt3d dispersion terms to right-hand side, when possible'),
                CheckboxButton(
                    'MVE6 FILEIN',
                    brief='Transport mover files',
                    button_text='Files...',
                    button_method='on_btn_mve6_filein'
                ),
                CheckboxButton(
                    'OBS6 FILEIN',
                    brief='Observation files',
                    button_text='Files...',
                    button_method='on_btn_obs6_filein'
                ),
            ]
        )
