"""CsubWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io import io_util
from xms.mf6.file_io.list_package_writer import ListPackageWriter


class CsubWriter(ListPackageWriter):
    """Writes the package to disk."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self._fp = None

    def _write_dimensions(self, fp):
        """Writes the dimensions block.

        Args:
            fp (_io.TextIOWrapper): The file.
        """
        self._data.maxbound = 0
        if 'PACKAGEDATA' in self._data.list_blocks:
            self._data.maxbound = io_util.count_max_line([self._data.list_blocks['PACKAGEDATA']])

        maxsig0 = 0
        if self._data.period_files:
            for file in self._data.period_files.values():
                if file:
                    nsig0 = io_util.count_max_line([file])
                    maxsig0 = max(maxsig0, nsig0)

        fp.write('\n')
        fp.write('BEGIN DIMENSIONS\n')
        fp.write(f'{io_util.mftab}NINTERBEDS {self._data.maxbound}\n')
        if maxsig0 > 0:
            fp.write(f'{io_util.mftab}MAXSIG0 {maxsig0}\n')
        fp.write('END DIMENSIONS\n')

    def _write_package(self, data):
        """Writes the package data to disk.

        Args:
            data (CsubData): The package data.
        """
        self._data = data
        with open(data.filename, 'w') as self._fp:
            self._write_comments(self._fp)
            self._write_options(self._fp)
            self._write_dimensions(self._fp)
            self._write_griddata(self._fp)
            if self._data.maxbound:
                self._write_list_block('PACKAGEDATA', self._fp)
            self._write_stress_periods(self._fp)
