"""HfbWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io import io_util
from xms.mf6.file_io.list_package_writer import ListPackageWriter


class HfbWriter(ListPackageWriter):
    """Writes a list package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self._data = None  # ListPackageData

    # @overrides
    def _write_dimensions(self, fp):
        """Writes the dimensions block.

        Args:
            fp (_io.TextIOWrapper): The file.
        """
        # Try updating using the database, and if that doesn't work, update using the files
        if not self._update_maxbound():
            self._data.maxbound = io_util.count_max_line(list(self._data.period_files.values()))
        fp.write('\n')
        fp.write('BEGIN DIMENSIONS\n')
        # MODFLOW complains if MAXBOUND is less than 1, even if there are no boundary conditions
        maxbound = max(1, self._data.maxbound)
        fp.write(f'{io_util.mftab}MAXHFB {maxbound}\n')
        fp.write('END DIMENSIONS\n')
