"""ObsWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import os

# 2. Third party modules

# 3. Aquaveo modules
from xms.core.filesystem import filesystem as fs

# 4. Local modules
from xms.mf6.file_io.list_package_writer import ListPackageWriter


class ObsWriter(ListPackageWriter):
    """Writes a OBS package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self._data = None  # ListPackageData

    def _write_list_blocks(self, fp):
        """Writes the CONTINUOUS FILEOUT blocks.

        Args:
            fp (_io.TextIOWrapper): file being written to
        """
        for block_key in self._data.list_blocks.keys():
            filename = block_key
            filename = filename.strip('\'')
            if self._writer_options.use_output_dir:
                filename = os.path.join(self._writer_options.output_dir, filename)
                filename = fs.compute_relative_path(self._writer_options.mfsim_dir, filename)
            if filename.find(' ') > 0:
                filename = f'\'{filename}\''
            self._write_list_block_extended('CONTINUOUS', block_key, f'FILEOUT {filename}', fp)

    def _write_package(self, data):
        """Writes the package file.

        Saves stress period data in external files using the OPEN/CLOSE option.
        """
        self._data = data
        with open(self._data.filename, 'w') as fp:
            self._write_comments(fp)
            self._write_options(fp)
            self._write_list_blocks(fp)
