"""Miscellaneous type aliases that have no local dependencies.py."""

__copyright__ = '(C) Copyright Aquaveo 2025'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import ActionRequest

# 4. Local modules

# Type aliases

Message = tuple[str, str]
"""First string is message level (DEBUG, ERROR, WARNING, INFO), second string is message text."""

Messages = list[Message]
"""List of Message."""

ActionRequests = list[ActionRequest]
"""List of ActionRequest."""

ActionRv = tuple[Messages, ActionRequests]
"""Return value for an action method: list of message tuples and list of ActionRequest."""
