"""Utilities for file io."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import logging

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

UNINITIALIZED_COMP_ID = -1


def export_ds_file(file_name, vals, ext='dat'):
    """Write an XMS ascii dataset file.

    Args:
        file_name (str): file name
        vals (list[float]): list of values to write
        ext (str): file extension
    """
    with open(f'{file_name}.{ext}', 'w') as f:
        f.write('DATASET\n')
        f.write("OBJTYPE 'UGRID'\n")
        f.write('BEGSCL\n')
        f.write(f'ND {len(vals)}\n')
        f.write(f"NAME '{file_name}'\n")
        f.write('TS 0 0\n')
        val_str = ''.join(f'{v}\n' for v in vals)
        f.write(val_str)
        f.write('ENDDS\n')


def get_logger():
    """Gets the logger used in file io tools.

    Returns:
        (logger): the logger
    """
    return logging.getLogger('xms.rsm')
