"""Module for the CoverageData class."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
from pathlib import Path
from typing import Optional

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.coverage_data import CoverageData as GmiCoverageData

# 4. Local modules


class CoverageData(GmiCoverageData):
    """Data manager for a coverage."""
    def __init__(self, main_file: Optional[str | Path] = None):
        """
        Initialize the class.

        Args:
            main_file: The main file to use. If omitted, uses a default one.
        """
        super().__init__(main_file)

    @property
    def _main_file_name(self):
        """What to name the data manager's main file."""
        return 'schism_coverage.nc'
