"""BcDataExitQ class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import pandas as pd
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules


class BcDataExitQ(param.Parameterized):
    """Bc type exit-q data."""
    discharge_option = param.ObjectSelector(
        label='Discharge option',
        default='Constant',
        objects=['Constant', 'Time series'],
        doc='option for specifying the Q',
        precedence=1,
    )
    constant_q = param.Number(
        label='Constant Q',
        default=0.0,
        doc='constant flow',
        precedence=2,
    )
    constant_q_units = param.ObjectSelector(
        label='',
        default='cfs',
        objects=['cfs', 'cms'],
        doc='units for constant Q',
        precedence=3,
    )
    time_series_q = param.DataFrame(
        default=pd.DataFrame(columns=['hrs', 'vol/sec']),
        doc='time series for Q',
        precedence=4,
    )
    time_series_q_units = param.ObjectSelector(
        label='',
        default='hrs -vs- cfs',
        objects=['hrs -vs- cfs', 'hrs -vs- cms'],
        doc='units for time series Q',
        precedence=5,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=['discharge_option'],
            depends={
                'Constant': ['constant_q', 'constant_q_units'],
                'Time series': ['time_series_q', 'time_series_q_units'],
            },
        )

    @param.depends('discharge_option', watch=True)
    def _update_discharge_option(self):
        """Watches changes made to the discharge_option object."""
        self.enabler.do_enabling(force_disable=False)
