"""MonitorPoint class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules


class MonitorPoint(param.Parameterized):
    """Data for monitor points."""
    label = param.String(label='Label', default='', doc='Label for the monitor point', precedence=0.9)
    observation_point = param.Boolean(
        label='Measured value',
        default=False,
        doc='check box to give observed value to monitor point',
        precedence=1,
    )
    water_surface_elevation = param.Number(
        default=0.0,
        doc='Observed value of water surface elevation. This should be a measurement from field data.',
        precedence=2,
    )
    water_surface_elevation_interval = param.Number(
        label='Acceptable error tolerance',
        default=0.1,
        doc='Acceptable error specified by user.',
        precedence=3,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=['observation_point'],
            depends={'observation_point': ['water_surface_elevation', 'water_surface_elevation_interval']},
        )

    @param.depends('observation_point', watch=True)
    def _update_observation_point(self):
        self.enabler.do_enabling(force_disable=False)
