"""ModelControlSrhW class."""
# 1. Standard python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.srh.data.model_control import ModelControl

# 4. Local modules
from xms.srhw.data.model_control_watershed import ModelControlWatershed

__copyright__ = "(C) Copyright Aquaveo 2022"
__license__ = "All rights reserved"


class ModelControlSrhW(ModelControl):
    """Manages data file for the hidden simulation component."""
    watershed = param.ClassSelector(
        label='',
        class_=ModelControlWatershed,
        doc='Watershed model control options',
        precedence=1,
    )

    def __init__(self):
        """Initializes the data class."""
        # call super first because we need the par magic to happen
        super().__init__()
        self.watershed = ModelControlWatershed()
