"""RainfallData class."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.srh.data.srh_coverage_data import SrhCoverageData

# 4. Local modules
from xms.srhw.data.par.rainfall_point_param import RainfallPoint

__copyright__ = "(C) Copyright Aquaveo 2022"
__license__ = "All rights reserved"


class RainfallData(SrhCoverageData):
    """Class for storing the SRH-W Rainfall properties."""

    def __init__(self, filename):
        """Constructor.

        Args:
            filename (:obj:`str`): file name
        """
        super().__init__(filename, 'SRHW_RAINFALL_DATA', 'point_data')

    @property
    def point_data(self):
        """Get the rainfall dataset.

        Returns:
            (:obj:`xarray.Dataset`): The rainfall_data list dataset

        """
        return self.data

    @point_data.setter
    def point_data(self, dset):
        """Setter for the _point_data dataset."""
        self.data = dset

    def rainfall_point_param_from_id(self, data_id):
        """Gets a record from an id. If the id is not in the point_data then returns None.

        Args:
            data_id (:obj:`int`): component id

        Returns:
            (:obj:`PointParam`): The record from the bc dataframe as a PointParam class
        """
        rain = RainfallPoint()
        return self.param_from_id(data_id, rain)

    def append_point_data_with_id(self, rainfall_point_data, data_id):
        """Sets a record with an id. If the id is < 1 then do nothing.

        Args:
            rainfall_point_data (:obj:`RainfallPoint`): instance of rainfall point data
            data_id (:obj:`int`): component id

        """
        self.append_param_data_with_id(rainfall_point_data, data_id)
