"""Worker thread for the solution importer."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import XmsEnvironment as XmEnv
from xms.guipy.dialogs.process_feedback_dlg import ProcessFeedbackDlg, ProcessFeedbackThread

# 4. Local modules


class SolutionLoadWorkerThread(ProcessFeedbackThread):
    """Worker thread for importing an STWAVE solution after a model run in SMS."""

    def __init__(self, sim_runner, parent):
        """Construct the worker.

        Args:
            sim_runner (SimulationRun): The simulation runner object.
            parent (QWidget): Parent of the QThread, probably the hidden parent dialog created by XMS.
        """
        super().__init__(parent=parent, do_work=self._do_work)
        self.sim_runner = sim_runner

    def _do_work(self):
        """Thread runner that exports the fort.14."""
        self.sim_runner._callback_read_solution()


def read_solution_feedback(sim_runner, win_cont):
    """Runs feedback dialog for read solution.

    Args:
        sim_runner (SimulationRun): The simulation runner object.
        win_cont (QtWidget): The window container object.
    """
    worker = SolutionLoadWorkerThread(sim_runner, win_cont)
    display_text = {
        'title': 'Loading STWAVE Solution Files',
        'working_prompt': 'Reading STWAVE solution files. Please wait...',
        'warning_prompt': 'Warning(s) encountered reading solution. Review log output for more details.',
        'error_prompt': 'Error(s) encountered reading solution. Review log output for more details.',
        'success_prompt': 'Successfully read STWAVE solution',
        'note': '',
        'auto_load': 'Auto load solution datasets into SMS when operation is complete',
    }
    feedback_dlg = ProcessFeedbackDlg(display_text, 'xms.stwave', worker, win_cont)
    feedback_dlg.testing = XmEnv.xms_environ_running_tests() == 'TRUE'
    feedback_dlg.exec()
