"""Exports the model files."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query
from xms.guipy.dialogs.feedback_thread import FeedbackThread

# 4. Local modules
from xms.swmm.dmi.xms_data import SwmmData
from xms.swmm.file_io import input_file_writer


class ModelNativeExportRunner(FeedbackThread):
    """Exports SWMM model .inp file."""

    def __init__(self, query: Query):
        """
        Construct the worker.

        Args:
            query: Interprocess communication object.
        """
        super().__init__(query, is_export=True, create_query=False)
        self._data = SwmmData(self._query)

    def _run(self):
        """Run the thread."""
        self._export_input_file()

    def _export_input_file(self):
        """Export the SWMM .inp file."""
        input_file_writer.write(self._data)
