"""RefineMeshTool class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.tool.ugrids.refine_ugrid_tool import RefineUGridTool

ARG_INPUT_GRID = 0
ARG_INPUT_LND = 1
ARG_OUTPUT_GRID = 2

DEFAULT_TOLERANCE = 0.000001  # XM_ZERO_TOL


class RefineMeshTool(RefineUGridTool):
    """Tool to refine a mesh."""

    def __init__(self):
        """Initializes the class."""
        super().__init__(name='Refine 2D Mesh')
        self._force_ugrid = False
        self._geom_txt = 'mesh'
