"""Helper functions for debugging purposes."""
import sys
import time


def wait_for_pydev():
    """Sleep while pydev isn't attached."""
    # VSCode will import pydevd when the debugger attaches we will just spin until we see it.
    while 'pydevd' not in sys.modules:
        time.sleep(0.3)

    # Now that pydevd is imported, it probably means someone attached a debugger. It also mean, though,
    # that we have access to the tools we need to check if there is a debugger attached, so lets do that first.
    import pydevd  # Don't worry if this can't be found. It will be added when the debugger attaches.
    while pydevd.get_global_debugger() is None or not pydevd.get_global_debugger().ready_to_run:
        time.sleep(0.3)
